/*
 * Decompiled with CFR 0.152.
 */
package com.android.chileaf.bluetooth.scanner;

import android.app.PendingIntent;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Parcelable;
import android.os.SystemClock;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresPermission;
import com.android.chileaf.bluetooth.scanner.BluetoothLeScannerCompat;
import com.android.chileaf.bluetooth.scanner.ScanCallback;
import com.android.chileaf.bluetooth.scanner.ScanFilter;
import com.android.chileaf.bluetooth.scanner.ScanRecord;
import com.android.chileaf.bluetooth.scanner.ScanResult;
import com.android.chileaf.bluetooth.scanner.ScanSettings;
import com.android.chileaf.bluetooth.scanner.ScannerService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class BluetoothLeScannerImplJB
extends BluetoothLeScannerCompat {
    @NonNull
    private final Map<ScanCallback, BluetoothLeScannerCompat.ScanCallbackWrapper> wrappers = new HashMap<ScanCallback, BluetoothLeScannerCompat.ScanCallbackWrapper>();
    @Nullable
    private HandlerThread handlerThread;
    @Nullable
    private Handler powerSaveHandler;
    private long powerSaveRestInterval;
    private long powerSaveScanInterval;
    private final Runnable powerSaveSleepTask = new Runnable(){

        @Override
        @RequiresPermission(allOf={"android.permission.BLUETOOTH_ADMIN", "android.permission.BLUETOOTH"})
        public void run() {
            BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
            if (adapter != null && BluetoothLeScannerImplJB.this.powerSaveRestInterval > 0L && BluetoothLeScannerImplJB.this.powerSaveScanInterval > 0L) {
                adapter.stopLeScan(BluetoothLeScannerImplJB.this.scanCallback);
                BluetoothLeScannerImplJB.this.powerSaveHandler.postDelayed(BluetoothLeScannerImplJB.this.powerSaveScanTask, BluetoothLeScannerImplJB.this.powerSaveRestInterval);
            }
        }
    };
    private final Runnable powerSaveScanTask = new Runnable(){

        @Override
        @RequiresPermission(allOf={"android.permission.BLUETOOTH_ADMIN", "android.permission.BLUETOOTH"})
        public void run() {
            BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
            if (adapter != null && BluetoothLeScannerImplJB.this.powerSaveRestInterval > 0L && BluetoothLeScannerImplJB.this.powerSaveScanInterval > 0L) {
                adapter.startLeScan(BluetoothLeScannerImplJB.this.scanCallback);
                BluetoothLeScannerImplJB.this.powerSaveHandler.postDelayed(BluetoothLeScannerImplJB.this.powerSaveSleepTask, BluetoothLeScannerImplJB.this.powerSaveScanInterval);
            }
        }
    };
    private final BluetoothAdapter.LeScanCallback scanCallback = new BluetoothAdapter.LeScanCallback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onLeScan(BluetoothDevice device, int rssi, byte[] scanRecord) {
            final ScanResult scanResult = new ScanResult(device, ScanRecord.parseFromBytes(scanRecord), rssi, SystemClock.elapsedRealtimeNanos());
            Map map = BluetoothLeScannerImplJB.this.wrappers;
            synchronized (map) {
                Collection scanCallbackWrappers = BluetoothLeScannerImplJB.this.wrappers.values();
                for (final BluetoothLeScannerCompat.ScanCallbackWrapper wrapper : scanCallbackWrappers) {
                    wrapper.handler.post(new Runnable(){

                        @Override
                        public void run() {
                            wrapper.handleScanResult(1, scanResult);
                        }
                    });
                }
            }
        }
    };

    BluetoothLeScannerImplJB() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_ADMIN", "android.permission.BLUETOOTH"})
    void startScanInternal(@NonNull List<ScanFilter> filters, @NonNull ScanSettings settings, @NonNull ScanCallback callback, @NonNull Handler handler) {
        boolean shouldStart;
        BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
        Map<ScanCallback, BluetoothLeScannerCompat.ScanCallbackWrapper> map = this.wrappers;
        synchronized (map) {
            if (this.wrappers.containsKey(callback)) {
                throw new IllegalArgumentException("scanner already started with given scanCallback");
            }
            BluetoothLeScannerCompat.ScanCallbackWrapper wrapper = new BluetoothLeScannerCompat.ScanCallbackWrapper(false, false, filters, settings, callback, handler);
            shouldStart = this.wrappers.isEmpty();
            this.wrappers.put(callback, wrapper);
        }
        if (this.handlerThread == null) {
            this.handlerThread = new HandlerThread(BluetoothLeScannerImplJB.class.getName());
            this.handlerThread.start();
            this.powerSaveHandler = new Handler(this.handlerThread.getLooper());
        }
        this.setPowerSaveSettings();
        if (shouldStart) {
            adapter.startLeScan(this.scanCallback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_ADMIN", "android.permission.BLUETOOTH"})
    void stopScanInternal(@NonNull ScanCallback callback) {
        boolean shouldStop;
        BluetoothLeScannerCompat.ScanCallbackWrapper wrapper;
        BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
        Map<ScanCallback, BluetoothLeScannerCompat.ScanCallbackWrapper> map = this.wrappers;
        synchronized (map) {
            wrapper = this.wrappers.remove(callback);
            shouldStop = this.wrappers.isEmpty();
        }
        if (wrapper == null) {
            return;
        }
        wrapper.close();
        this.setPowerSaveSettings();
        if (shouldStop) {
            adapter.stopLeScan(this.scanCallback);
            if (this.powerSaveHandler != null) {
                this.powerSaveHandler.removeCallbacksAndMessages(null);
            }
            if (this.handlerThread != null) {
                this.handlerThread.quitSafely();
                this.handlerThread = null;
            }
        }
    }

    @Override
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_ADMIN", "android.permission.BLUETOOTH"})
    void startScanInternal(@NonNull List<ScanFilter> filters, @NonNull ScanSettings settings, @NonNull Context context, @NonNull PendingIntent callbackIntent) {
        Intent service = new Intent(context, ScannerService.class);
        service.putParcelableArrayListExtra("com.android.chileaf.bluetooth.EXTRA_FILTERS", new ArrayList<ScanFilter>(filters));
        service.putExtra("com.android.chileaf.bluetooth.EXTRA_SETTINGS", (Parcelable)settings);
        service.putExtra("com.android.chileaf.bluetooth.EXTRA_PENDING_INTENT", (Parcelable)callbackIntent);
        service.putExtra("com.android.chileaf.bluetooth.EXTRA_START", true);
        context.startService(service);
    }

    @Override
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_ADMIN", "android.permission.BLUETOOTH"})
    void stopScanInternal(@NonNull Context context, @NonNull PendingIntent callbackIntent) {
        Intent service = new Intent(context, ScannerService.class);
        service.putExtra("com.android.chileaf.bluetooth.EXTRA_PENDING_INTENT", (Parcelable)callbackIntent);
        service.putExtra("com.android.chileaf.bluetooth.EXTRA_START", false);
        context.startService(service);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @RequiresPermission(value="android.permission.BLUETOOTH")
    public void flushPendingScanResults(@NonNull ScanCallback callback) {
        BluetoothLeScannerCompat.ScanCallbackWrapper wrapper;
        if (callback == null) {
            throw new IllegalArgumentException("callback cannot be null!");
        }
        Map<ScanCallback, BluetoothLeScannerCompat.ScanCallbackWrapper> map = this.wrappers;
        synchronized (map) {
            wrapper = this.wrappers.get(callback);
        }
        if (wrapper == null) {
            throw new IllegalArgumentException("callback not registered!");
        }
        wrapper.flushPendingScanResults();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPowerSaveSettings() {
        long minRest = Long.MAX_VALUE;
        long minScan = Long.MAX_VALUE;
        Map<ScanCallback, BluetoothLeScannerCompat.ScanCallbackWrapper> map = this.wrappers;
        synchronized (map) {
            for (BluetoothLeScannerCompat.ScanCallbackWrapper wrapper : this.wrappers.values()) {
                ScanSettings settings = wrapper.scanSettings;
                if (!settings.hasPowerSaveMode()) continue;
                if (minRest > settings.getPowerSaveRest()) {
                    minRest = settings.getPowerSaveRest();
                }
                if (minScan <= settings.getPowerSaveScan()) continue;
                minScan = settings.getPowerSaveScan();
            }
        }
        if (minRest < Long.MAX_VALUE && minScan < Long.MAX_VALUE) {
            this.powerSaveRestInterval = minRest;
            this.powerSaveScanInterval = minScan;
            if (this.powerSaveHandler != null) {
                this.powerSaveHandler.removeCallbacks(this.powerSaveScanTask);
                this.powerSaveHandler.removeCallbacks(this.powerSaveSleepTask);
                this.powerSaveHandler.postDelayed(this.powerSaveSleepTask, this.powerSaveScanInterval);
            }
        } else {
            this.powerSaveScanInterval = 0L;
            this.powerSaveRestInterval = 0L;
            if (this.powerSaveHandler != null) {
                this.powerSaveHandler.removeCallbacks(this.powerSaveScanTask);
                this.powerSaveHandler.removeCallbacks(this.powerSaveSleepTask);
            }
        }
    }
}

